<%--
$Header: AcctInfo.inc, 17, 1/18/01 4:04:56 PM, Schwartz, Joe$
$Log: 
 17   Alkindi Development1.16        1/18/01 4:04:56 PM   Schwartz, Joe  
      Changed String compareTo() to equals() where possible; renamed _SESSID
      constants to _SESSVAR.
 16   Alkindi Development1.15        1/10/01 3:34:25 PM   Schwartz, Joe  
      Modified to only call handlePostedDetails for the list(s) appropriate to
      the current page. 
 15   Alkindi Development1.14        1/8/01 7:08:57 PM    Schwartz, Joe   Fixed
      to handle email opt-in & out (CR 258).
 14   Alkindi Development1.13        1/5/01 1:18:25 PM    Schwartz, Joe   Added
      souce control keywords.
 13   Alkindi Development1.12        12/4/00 12:46:48 PM  Stanton, Sacha  
 12   Alkindi Development1.11        12/3/00 11:22:08 PM  Stanton, Sacha  
 11   Alkindi Development1.10        12/1/00 2:44:27 PM   Schwartz, Joe   
 10   Alkindi Development1.9         12/1/00 1:17:28 PM   Stanton, Sacha  
 9    Alkindi Development1.8         11/30/00 4:53:13 AM  Schwartz, Joe  
      Changed to properly test passwords and screen names.
 8    Alkindi Development1.7         11/30/00 3:08:29 AM  Schwartz, Joe   
 7    Alkindi Development1.6         11/29/00 3:01:05 PM  Schwartz, Joe   
 6    Alkindi Development1.5         11/28/00 2:34:42 PM  Stanton, Sacha  
 5    Alkindi Development1.4         11/24/00 9:44:48 PM  Stanton, Sacha  
 4    Alkindi Development1.3         11/22/00 3:28:10 PM  Schwartz, Joe   
 3    Alkindi Development1.2         11/22/00 1:03:05 PM  Schwartz, Joe   
 2    Alkindi Development1.1         11/18/00 7:39:56 PM  Schwartz, Joe   
 1    Alkindi Development1.0         11/18/00 10:52:09 AM Schwartz, Joe   
$
$NoKeywords$
--%><%!
///////////////////////////////////////////////////////////////////////
//
//	AcctInfo.inc 	--	common functions for dealing with
//						AccountInfo (user details).
//
//		Note: 	Include "Common.inc" before including this file.
//
//


//////////////////////////////////////////////////////////////
//
//		handlePostedAccountInfo()
//
//			Parses request parameters into the AccountInfo 
//			object supplied. This is used for member updates only.
//
//			NOTE: For security, does nothing with the password 
//			fields if both are empty.
public String handlePostedAcctInfo(AccountInfo ai, HttpServletRequest req) throws AlkExcept
{
	String errstr = "";

	//	Sex
	//
	String sex = req.getParameter(SEX_PARAM);
	if (sex != null) {
		ai.sex = Integer.parseInt(sex);
	}
	//	Education
	//
	String edu = req.getParameter(EDU_PARAM);
	if (edu != null) {
		ai.education = Integer.parseInt(edu);
	}
	//	Postal Code
	//
	String postalCode = req.getParameter(POSTALCODE_PARAM);
	if (postalCode != null) {
		ai.postalCode = postalCode;
	}
	//	Email
	//
	errstr += handlePostedEmail(ai, req);

	//	Forgot Password Q&A
	//
	if (req.getParameter(VALIDQ1_PARAM) != null) {
		errstr += handlePostedForgotPasswordInfo(ai, req);
	}
	//	Password
	//
	String pwd = req.getParameter(PWD_PARAM);
	String pwd2 = req.getParameter(PWD2_PARAM);
	if (pwd != null && pwd2 != null) {
		if (pwd.length() != 0 || pwd2.length() != 0) {
			errstr += handlePostedPassword(ai, req);
		}
	}

	//	ScreenName
	//
	errstr += handlePostedScreenName(ai, req);
	//	Birthday
	//
	errstr += handlePostedBirthDate(ai, req);

	//	Detail Lists
	//
	//		Only handle the detail list appropriate to the
	//		page.
	//
	String requestedDetails = req.getParameter(DETAILS_PAGE_PARAM);
	if (requestedDetails != null) {
		if (requestedDetails.equals(MY_DETAILS_OCC)) {
			errstr += handlePostedDetails(ai.professionList, req, PROFESSION_PARAM);
		}
		else if (requestedDetails.equals(MY_DETAILS_MOVIEPREF)) {
			errstr += handlePostedDetails(ai.genreList, req, GENRE_PARAM);
		}
		else if (requestedDetails.equals(MY_DETAILS_INTEREST)) {
			errstr += handlePostedDetails(ai.activityList, req, ACTIVITY_PARAM);
			errstr += handlePostedDetails(ai.interestList, req, INTEREST_PARAM);
			errstr += handlePostedDetails(ai.languageList, req, LANGUAGE_PARAM);
			errstr += handlePostedDetails(ai.sportList, req, SPORT_PARAM);
		}
	}

	//	Privacy
	//
	/*	The 'WantEmail' option is a checkbox, so if the form value is present,  
		the user checked it. On the other hand, if the form value is missing, 
		this does NOT mean that the user left the box unchecked. 
		The reason is that there are several versions of MyDetails.jsp which 
		post back to themselves, and the option checkbox may not have been on 
		the page the user was editing. For example, the 
		'MyDetails -- Occupation' page has no privacy options.
		
		Therefore, we test for the presence of another field which acts as a
		hint that the privacy option was available to the user and the page
		was submitted with the privacy option unchecked. 
	*/
	
	if (req.getParameter(WANTEMAIL_PARAM) != null) { 
		ai.wantsEmail = true;
	}
	else {
		if (req.getParameter(SCREENNAME_PARAM) != null)
			ai.wantsEmail = false;
	}
	return errstr;
}

//////////////////////////////////////////////////////////////
//
//	handlePostedEmail()
//
//		Validates posted email info.
//		Returns an error message or empty string.
//
String handlePostedEmail(AccountInfo ai, HttpServletRequest req) throws AlkExcept
{
	String errStr = "";
	String email = req.getParameter(EMAIL_PARAM);
	if (email != null) {
		email = email.toLowerCase();
		//	Check PRD 132
		//
		if (email.length() < 1 || !isEmailValid(email)) {
			errStr += getServletConfig().getServletContext().getInitParameter("MSG.PRD132") + "<br>";
		}
		else {
			ai.email = email;
		}
	}
	return errStr;
}

//////////////////////////////////////////////////////////////
//
//	handlePostedScreenName()
//
//		Validates posted Screen Name. 
//		Returns error message or empty string.
//
String handlePostedScreenName(AccountInfo ai, HttpServletRequest req) throws AlkExcept
{
	ServletContext ctx = getServletConfig().getServletContext();
	String errStr = "";
	String screenName = req.getParameter(SCREENNAME_PARAM);
	if (screenName != null) {
		ai.screenName = screenName;
		//	PRD 128
		//
		if (screenName.length() < 1) {
			errStr += ctx.getInitParameter("MSG.PRD128") + "<br>";
		}

		//	PRD 129
		//
		else if (screenName.length() > 15 || screenName.indexOf(' ') != -1) {
			errStr += ctx.getInitParameter("MSG.PRD129") + "<br>";
		}
		else {
			try {
				RE re = new RE("[^a-zA-Z01-9\\.\\-_]+");
				if (re.isMatch(screenName)) {
					//System.out.println("Invalid screen name character:" + screenName);
					errStr += ctx.getInitParameter("MSG.PRD129") + "<br>";
				}
				//else
				//	System.out.println("screenname chars ok: " + screenName);
			}
			catch(Exception e){
				throw new AlkExcept("Error checking Screen Name: " + e.toString(), 7060);
			}
		}

				
	}
	return errStr;
}

//////////////////////////////////////////////////////////////
//
//	handlePostedBirthDate()
//
//		Parses & validates birth date, but only if something 
//		was entered in one of the date fields.
//		Returns error message or empty string.
//
String handlePostedBirthDate(AccountInfo ai, HttpServletRequest req)
{
	String errStr = "";
	String bdayMM = req.getParameter(BDAY_MON_PARAM);
	String bdayDD = req.getParameter(BDAY_DATE_PARAM);
	String bdayYY = req.getParameter(BDAY_YEAR_PARAM);
	ServletContext ctx = getServletConfig().getServletContext();
	
	if (bdayMM != null) {
		if (bdayMM.length() > 0 || bdayDD.length() > 0 || bdayYY.length() > 0) {
			try {
				Calendar bdCal = Calendar.getInstance();
				bdCal.set(Integer.parseInt(bdayYY), Integer.parseInt(bdayMM) - 1, Integer.parseInt(bdayDD));
				Date bd = bdCal.getTime();
			//	System.out.println("bday = " + bd.toString());
				ai.birthDate = new java.sql.Date(bd.getTime());

				// PRD547: Compare birthdate with this day 13 years ago
				//
				Calendar compCal = Calendar.getInstance();
				int minAge = Integer.parseInt(ctx.getInitParameter("legal.minimum.user.age"));

				compCal.set(Calendar.YEAR, compCal.get(Calendar.YEAR) - minAge);
				Date compDate = compCal.getTime();
				if (bd.compareTo(compDate) > 0) {
					errStr += ctx.getInitParameter("MSG.PRD547");
				}
				
			}
			catch (Exception e) {
				errStr += ctx.getInitParameter("MSG.INVALID_DATE") + e.toString();
			}
		}
	}
	return errStr;
}

//////////////////////////////////////////////////////////////
//
//	handlePostedDetails()
//
//		Parses & validates the details posted with the given param
//		name into the given UserDetailList.
//
//		Note: This clears the list passed as an argument!
//		This should only be called when you want to either clear the
//		list or fill it in with form data.
//
//		Returns error message or empty string.
//
String handlePostedDetails(UserDetailList list, HttpServletRequest req, String paramName)
{
	String errStr = "";
	list.clear();
	String details[] = req.getParameterValues(paramName);
	if (details != null) {
		try {
			for (int idx = 0; idx < details.length; idx ++) {
				list.add(new UserDetailItem(Integer.parseInt(details[idx])));
			}
		}
		catch (NumberFormatException nfe) {
			errStr += "Bad activity ID: " + nfe.getMessage();
		}
	}
	return errStr;
}

//////////////////////////////////////////////////////////////
//
//	handlePostedPassword()
//
//		Parses & validates the password posted.
//		If OK, modifies the given AccountInfo's password.
//		Returns error message or empty string.
//
//
String handlePostedPassword(AccountInfo ai, HttpServletRequest req)
	throws AlkExcept
{
	String errStr = "";
	ServletContext ctx = getServletConfig().getServletContext();

	//	PRD 136
	//
	String pwd = req.getParameter(PWD_PARAM);
	if (null == pwd) {
		return ctx.getInitParameter("MSG.PRD136") + "<br>";
	}
	String pwd2 = req.getParameter(PWD2_PARAM);
	if (pwd.length() == 0 && pwd2.length() == 0) {
		return ctx.getInitParameter("MSG.PRD136") + "<br>";
	}
	if ( pwd.length() < 4 || pwd.length() > 16 || pwd.indexOf(' ') != -1 || pwd2.length() < 4 || pwd2.length() > 16 || pwd2.indexOf(' ') != -1) {
		errStr += ctx.getInitParameter("MSG.PRD136") + "<br>";
	}

	//	PRD 138
	//
	if (!pwd.equals(pwd2)) {
		errStr += ctx.getInitParameter("MSG.PRD138") + "<br>";
	}
	
	//	If OK, mod the AI to include the new password
	//
	if (errStr.length() == 0) {
		ai.password = pwd;
	}
	return errStr;
	
}

//////////////////////////////////////////////////////////////
//
//	handlePostedForgotPasswordInfo()
//
//		Validates the Forgot Password questions and answers
//
String handlePostedForgotPasswordInfo(AccountInfo ai, HttpServletRequest req)
{
	ServletContext ctx = getServletConfig().getServletContext();
	String errStr = "";
	ai.question1 = Integer.parseInt(req.getParameter(VALIDQ1_PARAM));
	ai.question2 = Integer.parseInt(req.getParameter(VALIDQ2_PARAM));
	ai.answer1 = req.getParameter(VALIDA1_PARAM);
	ai.answer2 = req.getParameter(VALIDA2_PARAM);
	if (ai.question1 == 0 || ai.question2 == 0) {
		errStr += ctx.getInitParameter("MSG.NO_PWD_QUESTION_SELECTED") + "<br>";
;
	}
	if ((ai.answer1.length() == 0) || (ai.answer2.length() == 0)) {
		errStr += ctx.getInitParameter("MSG.NO_PWD_ANSWER_SELECTED") + "<br>";
;
	}
	return errStr;
}
%>
